<?php
/**
 * User Login
 */
define('ECOMMERCE_ACCESS', true);
require_once '../config/db.php';
require_once '../config/auth.php';

// Redirect if logged in
if (isUserLoggedIn()) {
    header('Location: dashboard.php');
    exit;
}

$settings = getSettings();
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        $error = 'Invalid request. Please try again.';
    } else {
        $email = sanitize($_POST['email'] ?? '');
        $password = $_POST['password'] ?? '';
        
        if (empty($email) || empty($password)) {
            $error = 'Please enter email and password.';
        } elseif (!validateEmail($email)) {
            $error = 'Please enter a valid email.';
        } elseif (userLogin($email, $password)) {
            $redirect = $_SESSION['redirect_after_login'] ?? 'dashboard.php';
            unset($_SESSION['redirect_after_login']);
            header('Location: ' . $redirect);
            exit;
        } else {
            $error = 'Invalid email or password.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php echo htmlspecialchars($settings['site_name']); ?></title>
    <link rel="stylesheet" href="../assets/style.css">
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', system-ui, sans-serif; background: #f8fafc; min-height: 100vh; }
        .auth-container { min-height: 100vh; display: flex; }
        .auth-left { flex: 1; background: linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%); display: flex; align-items: center; justify-content: center; padding: 40px; }
        .auth-left-content { color: #fff; max-width: 400px; }
        .auth-left h1 { font-size: 36px; margin-bottom: 16px; }
        .auth-left p { font-size: 18px; opacity: 0.9; line-height: 1.6; }
        .auth-right { flex: 1; display: flex; align-items: center; justify-content: center; padding: 40px; }
        .auth-box { width: 100%; max-width: 420px; }
        .auth-header { text-align: center; margin-bottom: 32px; }
        .auth-header h2 { font-size: 28px; color: #0f172a; margin-bottom: 8px; }
        .auth-header p { color: #64748b; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: 500; color: #334155; }
        .form-group input { width: 100%; padding: 14px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 15px; transition: all 0.3s; }
        .form-group input:focus { outline: none; border-color: #0ea5e9; box-shadow: 0 0 0 4px rgba(14,165,233,0.1); }
        .btn-login { width: 100%; padding: 14px; background: #0ea5e9; color: #fff; border: none; border-radius: 10px; font-size: 16px; font-weight: 600; cursor: pointer; transition: all 0.3s; }
        .btn-login:hover { background: #0284c7; transform: translateY(-2px); }
        .error-message { background: #fef2f2; color: #dc2626; padding: 14px 18px; border-radius: 10px; margin-bottom: 24px; }
        .auth-footer { text-align: center; margin-top: 24px; color: #64748b; }
        .auth-footer a { color: #0ea5e9; text-decoration: none; font-weight: 500; }
        .auth-footer a:hover { text-decoration: underline; }
        .back-link { text-align: center; margin-top: 16px; }
        .back-link a { color: #64748b; text-decoration: none; }
        @media (max-width: 768px) {
            .auth-left { display: none; }
            .auth-right { padding: 20px; }
        }
    </style>
</head>
<body>
    <div class="auth-container">
        <div class="auth-left">
            <div class="auth-left-content">
                <h1><?php echo htmlspecialchars($settings['site_name']); ?></h1>
                <p>Welcome back! Sign in to access your account, track orders, and continue shopping.</p>
            </div>
        </div>
        <div class="auth-right">
            <div class="auth-box">
                <div class="auth-header">
                    <h2>Welcome Back</h2>
                    <p>Sign in to your account</p>
                </div>
                
                <?php if ($error): ?>
                <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>
                
                <form method="POST">
                    <?php echo csrfField(); ?>
                    
                    <div class="form-group">
                        <label for="email">Email Address</label>
                        <input type="email" id="email" name="email" required 
                               value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>"
                               placeholder="you@example.com">
                    </div>
                    
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" id="password" name="password" required 
                               placeholder="Enter your password">
                    </div>
                    
                    <button type="submit" class="btn-login">Sign In</button>
                </form>
                
                <div class="auth-footer">
                    Don't have an account? <a href="register.php">Create Account</a>
                </div>
                
                <div class="back-link">
                    <a href="../index.php">&larr; Back to Store</a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
