<?php
/**
 * User Registration
 */
define('ECOMMERCE_ACCESS', true);
require_once '../config/db.php';
require_once '../config/auth.php';

// Redirect if logged in
if (isUserLoggedIn()) {
    header('Location: dashboard.php');
    exit;
}

$settings = getSettings();
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid request. Please try again.';
    } else {
        $name = sanitize($_POST['name'] ?? '');
        $email = sanitize($_POST['email'] ?? '');
        $phone = sanitize($_POST['phone'] ?? '');
        $password = $_POST['password'] ?? '';
        $confirmPassword = $_POST['confirm_password'] ?? '';
        
        if (empty($name)) {
            $errors[] = 'Name is required.';
        }
        if (empty($email) || !validateEmail($email)) {
            $errors[] = 'Valid email is required.';
        }
        if (strlen($password) < 6) {
            $errors[] = 'Password must be at least 6 characters.';
        }
        if ($password !== $confirmPassword) {
            $errors[] = 'Passwords do not match.';
        }
        
        if (empty($errors)) {
            $result = userRegister($name, $email, $password, $phone);
            if ($result['success']) {
                $redirect = $_SESSION['redirect_after_login'] ?? 'dashboard.php';
                unset($_SESSION['redirect_after_login']);
                header('Location: ' . $redirect);
                exit;
            } else {
                $errors[] = $result['message'];
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - <?php echo htmlspecialchars($settings['site_name']); ?></title>
    <link rel="stylesheet" href="../assets/style.css">
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', system-ui, sans-serif; background: #f8fafc; min-height: 100vh; }
        .auth-container { min-height: 100vh; display: flex; }
        .auth-left { flex: 1; background: linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%); display: flex; align-items: center; justify-content: center; padding: 40px; }
        .auth-left-content { color: #fff; max-width: 400px; }
        .auth-left h1 { font-size: 36px; margin-bottom: 16px; }
        .auth-left p { font-size: 18px; opacity: 0.9; line-height: 1.6; }
        .auth-right { flex: 1; display: flex; align-items: center; justify-content: center; padding: 40px; }
        .auth-box { width: 100%; max-width: 420px; }
        .auth-header { text-align: center; margin-bottom: 32px; }
        .auth-header h2 { font-size: 28px; color: #0f172a; margin-bottom: 8px; }
        .auth-header p { color: #64748b; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: 500; color: #334155; }
        .form-group input { width: 100%; padding: 14px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 15px; transition: all 0.3s; }
        .form-group input:focus { outline: none; border-color: #0ea5e9; box-shadow: 0 0 0 4px rgba(14,165,233,0.1); }
        .btn-register { width: 100%; padding: 14px; background: #0ea5e9; color: #fff; border: none; border-radius: 10px; font-size: 16px; font-weight: 600; cursor: pointer; transition: all 0.3s; }
        .btn-register:hover { background: #0284c7; transform: translateY(-2px); }
        .error-list { background: #fef2f2; color: #dc2626; padding: 14px 18px; border-radius: 10px; margin-bottom: 24px; }
        .error-list ul { margin: 0; padding-left: 20px; }
        .auth-footer { text-align: center; margin-top: 24px; color: #64748b; }
        .auth-footer a { color: #0ea5e9; text-decoration: none; font-weight: 500; }
        .auth-footer a:hover { text-decoration: underline; }
        @media (max-width: 768px) {
            .auth-left { display: none; }
            .auth-right { padding: 20px; }
        }
    </style>
</head>
<body>
    <div class="auth-container">
        <div class="auth-left">
            <div class="auth-left-content">
                <h1><?php echo htmlspecialchars($settings['site_name']); ?></h1>
                <p>Join thousands of happy customers. Create your account and start shopping with exclusive deals and fast delivery.</p>
            </div>
        </div>
        <div class="auth-right">
            <div class="auth-box">
                <div class="auth-header">
                    <h2>Create Account</h2>
                    <p>Fill in your details to register</p>
                </div>
                
                <?php if (!empty($errors)): ?>
                <div class="error-list">
                    <ul>
                        <?php foreach ($errors as $error): ?>
                        <li><?php echo htmlspecialchars($error); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>
                
                <form method="POST">
                    <?php echo csrfField(); ?>
                    
                    <div class="form-group">
                        <label for="name">Full Name</label>
                        <input type="text" id="name" name="name" required 
                               value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>"
                               placeholder="Enter your full name">
                    </div>
                    
                    <div class="form-group">
                        <label for="email">Email Address</label>
                        <input type="email" id="email" name="email" required 
                               value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>"
                               placeholder="you@example.com">
                    </div>
                    
                    <div class="form-group">
                        <label for="phone">Phone Number</label>
                        <input type="tel" id="phone" name="phone" 
                               value="<?php echo htmlspecialchars($_POST['phone'] ?? ''); ?>"
                               placeholder="01XXXXXXXXX">
                    </div>
                    
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" id="password" name="password" required 
                               placeholder="Minimum 6 characters">
                    </div>
                    
                    <div class="form-group">
                        <label for="confirm_password">Confirm Password</label>
                        <input type="password" id="confirm_password" name="confirm_password" required 
                               placeholder="Re-enter password">
                    </div>
                    
                    <button type="submit" class="btn-register">Create Account</button>
                </form>
                
                <div class="auth-footer">
                    Already have an account? <a href="login.php">Sign In</a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
